<?php
error_reporting(0);
include 'koneksi.php';
include 'header2.php';

// **Ambil data hasil perhitungan dari tabel hasil2**
$hasil_perhitungan = query("SELECT * FROM hasil2 ORDER BY nilai DESC");

?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-5">
            <div class="card-header bg-success text-white text-center mb-1">
                <h2 class="text-center flex-grow-1 " style="font-size: 28px; font-weight: bold;">
                <i class="fas fa-check"></i> HASIL PERANKINGAN DAN KESIMPULAN</h2>
            </div>

            <br>

            <div class="card shadow-sm">
                <div class="card-body">
                    
                    <!-- **Cek jika hasil perhitungan kosong** -->
                    <?php if (empty($hasil_perhitungan)) : ?>
                        <div class="alert alert-danger text-center">
                            <strong>⚠️ Belum ada hasil perhitungan!</strong> Silakan lakukan proses perhitungan terlebih dahulu di halaman SPK.
                        </div>
                    <?php else : ?>

                        <!-- **Tampilkan hasil perangkingan** -->
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered text-center w-100" style="font-size: 18px;">
                                <thead class="table-success">
                                    <tr>
                                        <th style="width: 10%;">Peringkat</th>
                                        <th style="width: 50%;">Nama Channel</th>
                                        <th style="width: 20%;">Nilai Akhir</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $rank = 1; ?>
                                    <?php foreach ($hasil_perhitungan as $row) : ?>
                                        <tr <?= ($rank == 1)?>;>
                                            <td style="font-weight: bold;"><?= $rank++; ?></td>
                                            <td><?= htmlspecialchars($row['nama']); ?></td>
                                            <td style="font-weight: bold;"><?= number_format($row['nilai'], 6, '.', ''); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                        <br><br>

                        <div class="text-center">
                            <a href="proses2.php" class="btn btn-lg btn-outline-success">
                                <i class="fas fa-calculator"></i> Lihat Proses Perhitungan
                            </a>
                        </div>

                        <br><br>

                        <!-- **Kesimpulan Hasil Perhitungan** -->
                        <div class="card shadow-lg">
                            <div class="card-header bg-success text-white text-center">
                                <h4><i class="fas fa-lightbulb"></i> Kesimpulan</h4>
                            </div>
                            <div class="card-body">
                                <?php
                                // Cek apakah ada lebih dari satu alternatif dengan nilai tertinggi
                                $nilai_tertinggi = $hasil_perhitungan[0]['nilai'];
                                $alternatif_tertinggi = array_filter($hasil_perhitungan, function ($alt) use ($nilai_tertinggi) {
                                    return $alt['nilai'] == $nilai_tertinggi;
                                });

                                if (count($alternatif_tertinggi) > 1) : ?>
                                    <p class="text-justify" style="font-size: 18px;">
                                        Berdasarkan hasil perhitungan dengan metode <b>Weighted Product</b>, ditemukan bahwa terdapat <b><?= count($alternatif_tertinggi); ?></b> channel dengan nilai tertinggi yang sama.
                                        Hal ini menunjukkan bahwa beberapa channel memiliki kualitas setara dalam efektivitas penyampaian pembelajaran.
                                    </p>

                                    <p class="text-justify" style="font-size: 18px;">
                                        Berikut adalah daftar channel terbaik yang memiliki peringkat tertinggi:
                                    </p>

                                    <ul style="font-size: 18px;">
                                        <?php foreach ($alternatif_tertinggi as $alt) : ?>
                                            <li><b style="color: red;"><?= htmlspecialchars($alt['nama']); ?></b> dengan nilai akhir <b style="color: red;"><?= number_format($alt['nilai'], 6, '.', ''); ?></b></li>
                                        <?php endforeach; ?>
                                    </ul>

                                    <p class="text-justify" style="font-size: 18px;">
                                        Keberadaan lebih dari satu channel dengan skor tertinggi ini mengindikasikan bahwa beberapa channel YouTube telah memenuhi kriteria efektivitas pembelajaran.
                                        Faktor-faktor yang mendukung efektivitas ini mencakup jumlah views, jumlah subscribers, frekuensi unggah video, serta latar belakang konten kreator. 
                                        Oleh karena itu, channel-channel ini dapat digunakan sebagai referensi utama dalam pemilihan sumber pembelajaran bagi mahasiswa Teknik Informatika.
                                    </p>
                                    <p class="text-justify" style="font-size: 18px;">
                                        Selain itu, YouTube juga dapat dimanfaatkan oleh dosen sebagai media penyimpanan arsip perkuliahan atau rekaman sesi pembelajaran yang telah berlangsung.
                                        Hal ini memberikan fleksibilitas yang lebih tinggi dalam proses belajar-mengajar, di mana mahasiswa dapat mengakses materi kapan saja dan di mana saja.
                                        Dengan adanya rekaman perkuliahan yang terdokumentasi dengan baik, mahasiswa memiliki kesempatan untuk mengulang materi yang belum dipahami secara mendalam tanpa batasan waktu.
                                    </p>

                                    <p class="text-justify" style="font-size: 18px;">
                                        Fleksibilitas ini menjadikan YouTube sebagai platform pembelajaran yang adaptif, memungkinkan mahasiswa untuk belajar sesuai dengan kecepatan dan gaya belajar masing-masing.
                                        Selain itu, dosen juga dapat menggunakan YouTube sebagai media untuk menyusun materi pembelajaran yang lebih terstruktur dan dapat digunakan dalam jangka panjang sebagai referensi akademik yang bernilai.
                                    </p>
                                    <p class="text-justify" style="font-size: 18px;">
                                        Lebih lanjut, YouTube tidak hanya berfungsi sebagai sumber pembelajaran bagi mahasiswa, tetapi juga sebagai alat bantu bagi dosen dalam menyusun strategi pengajaran yang lebih efektif.
                                        Rekaman materi kuliah yang diunggah ke YouTube dapat dijadikan sebagai arsip pembelajaran, yang memungkinkan mahasiswa untuk mengakses ulang materi yang telah diberikan kapan saja sesuai dengan kebutuhan akademik mereka.
                                    </p>

                                    <p class="text-justify" style="font-size: 18px;">
                                        Dengan adanya dokumentasi pembelajaran dalam format video, dosen dapat melakukan analisis terhadap metode pengajaran yang telah diterapkan serta mengevaluasi efektivitasnya.
                                        Dengan demikian, YouTube tidak hanya berperan dalam menyediakan aksesibilitas materi yang lebih luas bagi mahasiswa, tetapi juga mendukung peningkatan kualitas pengajaran di lingkungan akademik secara lebih berkelanjutan.
                                    </p>


                                <?php else : ?>
                                    <p class="text-justify" style="font-size: 18px;">
                                        Berdasarkan hasil perhitungan dengan metode <b>Weighted Product</b>, channel dengan peringkat tertinggi adalah 
                                        <b style="color: red;"><?= htmlspecialchars($hasil_perhitungan[0]['nama']); ?></b>, dengan nilai akhir 
                                        <b style="color: red;"><?= number_format($hasil_perhitungan[0]['nilai'], 6, '.', ''); ?></b>. 
                                        Channel ini unggul dalam berbagai aspek seperti jumlah views, jumlah subscribers, dan frekuensi unggah video yang tinggi, 
                                        sehingga direkomendasikan sebagai media pembelajaran terbaik untuk mahasiswa Teknik Informatika.
                                    </p>

                                    <p class="text-justify" style="font-size: 18px;">
                                        Channel dengan peringkat selanjutnya juga memiliki kualitas yang baik, namun terdapat perbedaan skor pada beberapa kriteria yang mempengaruhi hasil akhir. 
                                        Dengan demikian, daftar peringkat ini dapat digunakan sebagai acuan dalam memilih channel YouTube yang paling sesuai dengan kebutuhan pembelajaran.
                                    </p>
                                    <p class="text-justify" style="font-size: 18px;">
                                        Selain itu, YouTube juga dapat dimanfaatkan oleh dosen sebagai media penyimpanan arsip perkuliahan atau rekaman sesi pembelajaran yang telah berlangsung.
                                        Hal ini memberikan fleksibilitas yang lebih tinggi dalam proses belajar-mengajar, di mana mahasiswa dapat mengakses materi kapan saja dan di mana saja.
                                        Dengan adanya rekaman perkuliahan yang terdokumentasi dengan baik, mahasiswa memiliki kesempatan untuk mengulang materi yang belum dipahami secara mendalam tanpa batasan waktu.
                                    </p>

                                    <p class="text-justify" style="font-size: 18px;">
                                        Fleksibilitas ini menjadikan YouTube sebagai platform pembelajaran yang adaptif, memungkinkan mahasiswa untuk belajar sesuai dengan kecepatan dan gaya belajar masing-masing.
                                        Selain itu, dosen juga dapat menggunakan YouTube sebagai media untuk menyusun materi pembelajaran yang lebih terstruktur dan dapat digunakan dalam jangka panjang sebagai referensi akademik yang bernilai.
                                    </p>
                                    <p class="text-justify" style="font-size: 18px;">
                                        Lebih lanjut, YouTube tidak hanya berfungsi sebagai sumber pembelajaran bagi mahasiswa, tetapi juga sebagai alat bantu bagi dosen dalam menyusun strategi pengajaran yang lebih efektif.
                                        Rekaman materi kuliah yang diunggah ke YouTube dapat dijadikan sebagai arsip pembelajaran, yang memungkinkan mahasiswa untuk mengakses ulang materi yang telah diberikan kapan saja sesuai dengan kebutuhan akademik mereka.
                                    </p>

                                    <p class="text-justify" style="font-size: 18px;">
                                        Dengan adanya dokumentasi pembelajaran dalam format video, dosen dapat melakukan analisis terhadap metode pengajaran yang telah diterapkan serta mengevaluasi efektivitasnya.
                                        Dengan demikian, YouTube tidak hanya berperan dalam menyediakan aksesibilitas materi yang lebih luas bagi mahasiswa, tetapi juga mendukung peningkatan kualitas pengajaran di lingkungan akademik secara lebih berkelanjutan.
                                    </p>



                                <?php endif; ?>
                            </div>
                        </div>

                        <br>

                        <!-- **Form Export ke PDF** -->
                        <div class="text-center">
                            <p style="font-size: 18px;">⬇ *Unduh hasil dalam format PDF*</p>
                            <form action="reportpdf2.php" method="post">
                                <button type="submit" class="btn btn-lg btn-danger" name="submit">
                                    <i class="fas fa-file-pdf"></i> Unduh PDF
                                </button>
                            </form>
                        </div>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </main>
</div>
